;----------------------------------------------------------------------------
;    MODULE NAME:   TryMeWithFixedGuids.MM
;
;        $Author:   USER "Dennis"  $
;      $Revision:   1.8  $
;          $Date:   22 Jun 2006 19:14:24  $
;       $Logfile:   C:/DBAREIS/Projects.PVCS/Win32/MakeMsi/TryMeWithFixedGuids.MM.pvcs  $
;
; DESCRIPTION
; ~~~~~~~~~~~
; Slightly more complicate example than "TryMe.MM".
;
; You should probably have a look at and build "TryMe.MM" before this
; one!  Since it uses the same version file it shares update codes and all
; other information (product name etc).
;
; This example shows how GUID values can be controlled more.
; I personally would stick with major upgrades unless you have no option as
; this simplifies things greatly.
;
; NOTES
; ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
; * The "UpgradeCode" has been set in the ".VER" file.
;
; * I normally don't care about the package, product or component guids as
;   my installs are all "major" however this shows how you can have as much
;   control over the MSI you need to support minor upgrades and similar at the
;   cost of much more complexity and the need to know much more about Windows
;   Installer internals and the complex upgrade rules.
;
; * As with all the examples I could have used a different approach, for
;   example, named GUIDs which would allow MAKEMSI to create a GUID the first
;   time and then maintain these values.
;----------------------------------------------------------------------------

;--- Override some MAKEMSI options ------------------------------------------
#define  VER_FILENAME.VER  TryMe.Ver  ;;I only want one VER file for all samples!


;--- Define GUID values (probably good idea to keep together) ---------------
#define Guid.Msi.ProductCode   {FBBEE0FA-FAFC-4009-A1B8-CE19A6921380}
#define Guid.Msi.PackageCode   {327193CF-3511-4E30-B6A1-8709DF0435D2}
#define Guid.Component.TryMe   {79A5FFAA-3FE3-4EDB-B32B-04F4EE3A3465}
#define Guid.Component.MmDoco  {E9E56010-AE2C-406F-BE1D-4C01EF0B6E9D}


;--- Handle Package and Product codes (recommend you place this in "common" header file) ---
;---[PutInCommonHeader]---
#( '<?NewLine>'
   #define COMPANY_SET_PROPERTY_PRODUCTCODE

   #define VBSRET.GUID.ProductCode <$Guid.Msi.ProductCode>   ;;For HTML report's summary
   <$Property "ProductCode" Value='<$Guid.Msi.ProductCode>'>
#)
#( '<?NewLine>'
   #define COMPANY_SET_PROPERTY_PACKAGECODE

   #define VBSRET.GUID.PackageCode <$Guid.Msi.PackageCode>   ;;For HTML report's summary
   <$Summary  "PackageCode" Value='<$Guid.Msi.PackageCode>'>
#)
#define COMPANY_HTMLRPT_DOCO_COMPONENTS_GUID  <$Guid.Component.MmDoco>  ;;Component Autogenerated by "COMPANY.MMH"
;---[PutInCommonHeader]---

;--- Include MAKEMSI support (with my customisations and MSI branding) ------
#include "ME.MMH"

;--- Create INSTALLDIR ------------------------------------------------------
<$DirectoryTree Key="INSTALLDIR" Dir="c:\program files\TryMe (makemsi sample)\<$MAKEMSI_MM_BASENAME>" CHANGE="\" PrimaryFolder="Y">

;--- Add "TRY.MM" and shortcut to same component (file must be keypath) -----
<$Component "TryMe" Create="Y" Directory_="INSTALLDIR" ComponentId=^<$Guid.Component.TryMe>^>
    ;--- Add the files to the "TryMe" component -----------------------------
    <$File SOURCE="TryMeShortcuts.MM" KeyPath="Y">

    ;--- Add the shortcut (advertise the "complete" feature) ----------------
    #(
        ;--- Advertised shortcut in "Start->programs" -----------------------
        <$Shortcut
                   Dir="ProgramMenuFolder"
               Feature="."
                 Title="Open <?InputFile $$FilePart:NAME> (via default association)"
           Description=^Simply opens "TryMeShortcuts.MM" in associated handler (probably notepad)!^
                  Icon="@.\TryMe.ico"
               WorkDir="INSTALLDIR"
        >
    #)
<$/Component>

